/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.jspemul;

import com.ibm.hwmca.fw.servlet.jspemul.TagInfoEmul;
import com.ibm.hwmca.fw.servlet.jspemul.TagLibInfoImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TLDParser {
    static DocumentBuilderFactory factory;
    InputStream tldStream;
    TLDHandler handler;
    TagLibInfoImpl tagLibInfo;

    public static TagLibraryInfo parseTLD(InputStream tldStream) throws JspException, IOException {
        return new TLDParser(tldStream).parseTLD();
    }

    private TLDParser(InputStream tldStream) {
        this.tldStream = tldStream;
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setCoalescing(true);
            factory.setIgnoringComments(true);
        }
        return factory;
    }

    protected TagLibraryInfo parseTLD() throws JspException, IOException {
        DocumentBuilderFactory factory = TLDParser.getDocumentBuilderFactory();
        this.handler = new TLDHandler();
        this.tagLibInfo = new TagLibInfoImpl();
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(this.handler);
            parser.setEntityResolver(this.handler);
            Document document = parser.parse(this.tldStream);
            Element root = document.getDocumentElement();
            if (!root.getNodeName().equals("taglib")) {
                throw new SAXException("Root element must be \"taglib\".  Found \"" + root.getNodeName() + "\" instead.");
            }
            this.processTaglibNode(root);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return this.tagLibInfo;
    }

    private String getBodyChars(Node parent) throws JspException {
        Node child = parent.getFirstChild();
        if (child.getNodeType() != 3) {
            throw new JspException("TLD Format Error: Expected child node of element \"" + parent.getNodeName() + "\" to be text.");
        }
        return child.getNodeValue().trim();
    }

    private boolean getBodyCharsAsBoolean(Node parent) throws JspException {
        String value = this.getBodyChars(parent);
        if (value.equals("true") || value.equals("yes")) {
            return true;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        throw new JspException("TLD Format Error: Child node of element \"" + parent.getNodeName() + "\" must be true|false|yes|no.");
    }

    private void processTaglibNode(Element parent) throws JspException {
        ArrayList<TagInfoEmul> parsedTags = new ArrayList<TagInfoEmul>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName().intern();
            if (name == "tlibversion" || name == "tlib-version") {
                this.tagLibInfo.setTagLibraryVersion(this.getBodyChars(child));
            } else if (name == "jspversion" || name == "jsp-version") {
                this.tagLibInfo.setRequiredVersion(this.getBodyChars(child));
            } else if (name == "shortname" || name == "short-name") {
                this.tagLibInfo.setShortName(this.getBodyChars(child));
            } else if (name == "uri") {
                this.tagLibInfo.setURI(this.getBodyChars(child));
            } else if (name == "info" || name == "description") {
                this.tagLibInfo.setInfoString(this.getBodyChars(child));
            } else if (name == "validator") {
                this.tagLibInfo.setTagLibraryValidator(this.createValidator(child));
            } else if (name == "tag") {
                parsedTags.add(this.createTag(child));
            } else if (name != "display-name" && name != "small-icon" && name != "large-icon" && name != "listener") {
                throw new JspException("TLD Format Error: Unrecognized child element of \"" + parent.getNodeName() + "\": " + name);
            }
            TagInfo[] tags = new TagInfoEmul[parsedTags.size()];
            parsedTags.toArray(tags);
            this.tagLibInfo.setTags(tags);
        }
    }

    private TagLibraryValidator createValidator(Node parent) {
        return null;
    }

    private TagInfoEmul createTag(Node parent) throws JspException {
        String tagname = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        ArrayList<TagAttributeInfo> attributes = new ArrayList<TagAttributeInfo>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName().intern();
            if (name == "name") {
                tagname = this.getBodyChars(child);
                continue;
            }
            if (name == "tagclass" || name == "tag-class") {
                tagclass = this.getBodyChars(child);
                continue;
            }
            if (name == "teiclass" || name == "tei-class") {
                teiclass = this.getBodyChars(child);
                continue;
            }
            if (name == "bodycontent" || name == "body-content") {
                bodycontent = this.getBodyChars(child);
                continue;
            }
            if (name == "display-name") {
                displayName = this.getBodyChars(child);
                continue;
            }
            if (name == "small-icon") {
                smallIcon = this.getBodyChars(child);
                continue;
            }
            if (name == "large-icon") {
                largeIcon = this.getBodyChars(child);
                continue;
            }
            if (name == "info" || name == "description") {
                info = this.getBodyChars(child);
                continue;
            }
            if (name == "variable") continue;
            if (name == "attribute") {
                attributes.add(this.createAttribute(child));
                continue;
            }
            if (name == "example") continue;
            throw new JspException("TLD Format Error: Unrecognized child element of \"" + parent.getNodeName() + "\": " + name);
        }
        TagAttributeInfo[] attrs = new TagAttributeInfo[attributes.size()];
        attributes.toArray(attrs);
        TagExtraInfo tagExtraInfo = null;
        if (teiclass != null && teiclass.length() > 0) {
            try {
                Class<?> teiClassObj = this.getClass().getClassLoader().loadClass(teiclass);
                tagExtraInfo = (TagExtraInfo)teiClassObj.newInstance();
            }
            catch (Exception e) {
                throw new JspException("TLD Error: teiclass \"" + teiclass + "\" failed to load: " + e, (Throwable)e);
            }
        }
        TagInfoEmul tagInfo = new TagInfoEmul(tagname, tagclass, bodycontent, info, this.tagLibInfo, tagExtraInfo, attrs);
        return tagInfo;
    }

    private TagAttributeInfo createAttribute(Node parent) throws JspException {
        String attributeName = null;
        boolean required = false;
        boolean rtexprvalue = false;
        String type = null;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName().intern();
            if (name == "name") {
                attributeName = this.getBodyChars(child);
                continue;
            }
            if (name == "required") {
                required = this.getBodyCharsAsBoolean(child);
                continue;
            }
            if (name == "rtexprvalue") {
                rtexprvalue = this.getBodyCharsAsBoolean(child);
                continue;
            }
            if (name == "type") {
                type = this.getBodyChars(child);
                continue;
            }
            if (name == "description") continue;
            throw new JspException("TLD Format Error: Unrecognized child element of \"" + parent.getNodeName() + "\": " + name);
        }
        return new TagAttributeInfo(attributeName, required, type, rtexprvalue);
    }

    protected static class TLDHandler
    implements ErrorHandler,
    EntityResolver {
        protected TLDHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("TLD parse warning" + this.formatException(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            System.out.println("TLD parse error" + this.formatException(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("TLD parse fatal error" + this.formatException(exception));
        }

        private String formatException(SAXParseException exception) {
            StringBuffer w = new StringBuffer();
            w.append(" at ");
            String s = exception.getPublicId();
            if (s != null) {
                w.append("public id == \"");
                w.append(s);
                w.append("\", ");
            }
            if ((s = exception.getSystemId()) != null) {
                w.append("system id == \"");
                w.append(s);
                w.append("\", ");
            }
            w.append("line==");
            w.append(exception.getLineNumber());
            w.append(", column==");
            w.append(exception.getColumnNumber());
            w.append(": ");
            w.append(exception.getMessage());
            return w.toString();
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource entity = new InputSource(new ByteArrayInputStream(new byte[0]));
            entity.setPublicId(publicId);
            entity.setSystemId(systemId);
            return entity;
        }
    }
}

